<?php

$token = "7834264778:AAHgOp7WbH-_yHk5k_5CLF4As03G7DceiAQ"; // bot token
$admin = "108950403"; 

// تابع برای ارسال درخواست به API تلگرام
function bot($method, $datas = [])
{
    global $token;
    $ch = curl_init();
    curl_setopt_array($ch, array(
        CURLOPT_URL => 'https://api.telegram.org/bot' . $token . '/' . $method,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POSTFIELDS => $datas
    ));
    return json_decode(curl_exec($ch));
}

// دریافت داده‌های ورودی از تلگرام
$update = json_decode(file_get_contents('php://input'));
if (isset($update)) {
    $message = $update->message ?? null;
    $text = $message->text ?? null;
    $chat_id = $message->chat->id ?? null;
}

// خواندن اطلاعات دیتابیس
$db = json_decode(file_get_contents('db.json'), true);
$step = $db['step'];

// کلیدهای کیبورد
$home = json_encode([
    'resize_keyboard' => true,
    'keyboard' => [[['text' => "افزودن پاسخ خودکار ✉️"]], [['text' => "حذف پاسخ خودکار 🚫"]]]
]);
$back = json_encode([
    'resize_keyboard' => true,
    'keyboard' => [[['text' => "بازگشت 🔙"]]]
]);

// پیام خوش‌آمدگویی
if ($chat_id == $admin) {
    if ($text == '/start' || $text == 'بازگشت 🔙') {
        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "👋 سلام، به ربات مدیریت حساب بیزینسی خوش آمدید!\n\n📌 از منوی زیر برای تنظیم پاسخ‌های خودکار استفاده کنید.",
            'reply_markup' => $home
        ]);
        $db['step'] = "";
        file_put_contents("db.json", json_encode($db));
    }
    // افزودن پاسخ خودکار
    elseif ($text == 'افزودن پاسخ خودکار ✉️') {
        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "✍️ لطفاً متنی را که می‌خواهید ربات به آن پاسخ دهد، ارسال کنید.",
            'reply_markup' => $back
        ]);
        $db['step'] = "add-1";
        file_put_contents("db.json", json_encode($db));
    }
    // حذف پاسخ خودکار
    elseif ($text == 'حذف پاسخ خودکار 🚫') {
        if (!empty($db['data'])) {
            $list = "";
            foreach ($db['data'] as $item) {
                $list .= "📌 " . htmlspecialchars($item['text']) . "\n";
            }
            bot('sendMessage', [
                'chat_id' => $chat_id,
                'text' => "🔍 لیست پاسخ‌های خودکار:\n\n" . $list . "\n\nبرای حذف، یکی از این متن‌ها را ارسال کنید.",
                'reply_markup' => $back
            ]);
            $db['step'] = "remove";
            file_put_contents("db.json", json_encode($db));
        } else {
            bot('sendMessage', [
                'chat_id' => $chat_id,
                'text' => "⚠️ هیچ پاسخ خودکاری تنظیم نشده است!",
                'reply_markup' => $home
            ]);
        }
    }
    // ذخیره مرحله اول (متن موردنظر)
    elseif ($step == 'add-1') {
        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "✅ متنی که می‌خواهید پاسخ دهید ذخیره شد.\nحالا پاسخ مناسب را ارسال کنید (متن، عکس، ویدیو و ...).",
            'reply_markup' => $back
        ]);
        $db['data'][] = ['text' => $text, 'answers' => []];
        $db['step'] = "add-2";
        file_put_contents("db.json", json_encode($db));
    }
    // ذخیره مرحله دوم (پاسخ)
    elseif ($step == 'add-2') {
        end($db['data']);
        $last_key = key($db['data']);

        // تشخیص نوع پیام (متن، عکس، ویدیو و ...)
        if ($text) {
            $type = "text";
            $content = $text;
        } elseif ($message->photo) {
            $type = "photo";
            $content = end($message->photo)->file_id;
        } elseif ($message->video) {
            $type = "video";
            $content = $message->video->file_id;
        } elseif ($message->voice) {
            $type = "voice";
            $content = $message->voice->file_id;
        } elseif ($message->sticker) {
            $type = "sticker";
            $content = $message->sticker->file_id;
        } else {
            bot('sendMessage', ['chat_id' => $chat_id, 'text' => "⛔ نوع فایل پشتیبانی نمی‌شود!"]);
            exit;
        }

        // ذخیره پاسخ
        $db['data'][$last_key]['answers'][] = ['type' => $type, 'content' => $content];
        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "✅ پاسخ ثبت شد.\nمی‌توانید پاسخ دیگری ارسال کنید یا روی 'بازگشت' کلیک کنید.",
            'reply_markup' => $back
        ]);
        file_put_contents("db.json", json_encode($db));
    }
    // حذف پاسخ خودکار
    elseif ($step == 'remove') {
        foreach ($db['data'] as $key => $item) {
            if ($item['text'] == $text) {
                unset($db['data'][$key]);
                file_put_contents("db.json", json_encode($db));
                bot('sendMessage', [
                    'chat_id' => $chat_id,
                    'text' => "✅ پاسخ خودکار حذف شد.",
                    'reply_markup' => $home
                ]);
                break;
            }
        }
    }
}

// بررسی و ارسال پاسخ خودکار
if ($message && $chat_id != $admin) {
    foreach ($db['data'] as $item) {
        if ($item['text'] == $text) {
            foreach ($item['answers'] as $answer) {
                bot('send' . ucfirst($answer['type']), [
                    'chat_id' => $chat_id,
                    ($answer['type'] == "text" ? 'text' : 'file_id') => $answer['content']
                ]);
            }
            break;
        }
    }
}
?>
